﻿$currentDir = $PSScriptRoot
$wshell = New-Object -ComObject Wscript.Shell
$popupTitle = "Importowanie certyfikatu do weryfikacji plików podpisanych cyfrowo"

if (![Environment]::Is64BitProcess)
{
  $wshell.Popup("Skrypt został uruchomiony w 32-bitowej wersji PowerShell. Wymagana jest wersja 64-bitowa", 0, $popupTitle, 16)

  Exit 1
}

$myWindowsPrincipal = new-object System.Security.Principal.WindowsPrincipal([System.Security.Principal.WindowsIdentity]::GetCurrent())

if (!$myWindowsPrincipal.IsInRole([System.Security.Principal.WindowsBuiltInRole]::Administrator))
{
  Exit (Start-Process PowerShell.exe -ArgumentList "-ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb runAs -WindowStyle Hidden -Wait -PassThru).ExitCode
}

try
{
  $certName = "TelWin SCADA"
  $certFileName = "TelWin_SCADA"
  $certPath = $currentDir + "\" + $certFileName + ".p7b"
  $pathExists = Test-Path $certPath

  if ($pathExists -eq $False)
  {
    $wshell.Popup("Błąd`: Brak pliku z certyfikatem " + $certPath, 0, $popupTitle, 16)

    Exit 10
  }

  $certNamePattern = "*CN=" + $certName + "*"
  $certStoreLocation = "Cert:\LocalMachine"
  $certList = Get-ChildItem $certStoreLocation -Recurse | Where-Object Subject -like $certNamePattern

  foreach ($cert in $certList)
  {
    if ($cert.Thumbprint -ne $certPfx.Thumbprint)
    {
      $cert | Remove-Item
    }
  }


  $certNamePattern = "*CN=" + "TEL-STER Root CA v3" + "*"
  $certList = Get-ChildItem $certStoreLocation -Recurse | Where-Object Subject -like $certNamePattern

  foreach ($cert in $certList)
  {
    if ($cert.Thumbprint -ne $certPfx.Thumbprint)
    {
      $cert | Remove-Item
    }
  }
  
  $certNamePattern = "*CN=" + "TEL-STER CodeSigning CA v1" + "*"
  $certList = Get-ChildItem $certStoreLocation -Recurse | Where-Object Subject -like $certNamePattern

  foreach ($cert in $certList)
  {
    if ($cert.Thumbprint -ne $certPfx.Thumbprint)
    {
      $cert | Remove-Item
    }
  }


  $certStoreLocation = "Cert:\LocalMachine\TrustedPublisher"

  Import-Certificate -FilePath "$certPath" -CertStoreLocation $certStoreLocation

  $certStoreLocation = "Cert:\LocalMachine\Root"

  Import-Certificate -FilePath "$certPath" -CertStoreLocation $certStoreLocation

  $wshell.Popup("Operacja zakończona poprawnie.", 0, $popupTitle, 4160)
}
catch
{
  $wshell.Popup("Błąd`: $($PSItem.ToString())", 0, $popupTitle, 16)

  Exit 100
}

Exit 0

# SIG # Begin signature block
# MIIP5QYJKoZIhvcNAQcCoIIP1jCCD9ICAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCBGnblU+YPQ/KJO
# 8v1AmFRzGX56jMZrObF8tTqowKVUkqCCDQYwggWzMIIDm6ADAgECAgEBMA0GCSqG
# SIb3DQEBCwUAMH0xCzAJBgNVBAYTAlBMMREwDwYDVQQKEwhURUwtU1RFUjEUMBIG
# A1UECxMLVEVMLVNURVIgQ0ExIzAhBgNVBAMTGlRFTC1TVEVSIENvZGVTaWduaW5n
# IENBIHYxMSAwHgYJKoZIhvcNAQkBFhFiaXVyb0B0ZWwtc3Rlci5wbDAeFw0yMTAy
# MTAyMjExMzVaFw0zMTAyMDgyMjExMzVaMGYxCzAJBgNVBAYTAlBMMREwDwYDVQQK
# EwhURUwtU1RFUjELMAkGA1UECxMCSVQxFTATBgNVBAMTDFRlbFdpbiBTQ0FEQTEg
# MB4GCSqGSIb3DQEJARYRYml1cm9AdGVsLXN0ZXIucGwwggEiMA0GCSqGSIb3DQEB
# AQUAA4IBDwAwggEKAoIBAQCk8p1f0HoDXhMp5Q5+vX2bhdaXmwJcnKhFRZjYkA4k
# 7nEmlAmFWAnPwffi8TTCiW5waJOSH6nsBVBfB9OP29jnZWnsJ3a6mlQyRkC/GH8y
# 7kkbQ41WkjtCQMxvIvyH6ZItR5a9hWmWBO7H7ZzAKOFuif+dfLtqkFVCvRo09SJN
# ylAhWJMt2xXWST8Tzi+fDi15rFxVCvJ7WfSVeMhkx9AgAR0zjTOEyj/nvYigiUa1
# 0O5WvmwLDuZUulhPE5XYpyoexYUB+Ot9QRbfDN2jhWtQqFDHvn5jkPx+8/bCBsDy
# SPm+j33v5i65hXjqcINoNnxzX6WlZY7f/gK0qopeZ3sDAgMBAAGjggFTMIIBTzAM
# BgNVHRMBAf8EAjAAMAsGA1UdDwQEAwIHgDAdBgNVHQ4EFgQUuUAeWmM7diS7LQ3p
# 7lQmrND+ZPswHwYDVR0jBBgwFoAUm1Mr3lehts9MErumlu3Otp/s07MwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwMwUQYIKwYBBQUHAQEERTBDMEEGCCsGAQUFBzAChjVo
# dHRwOi8vdGVsLXN0ZXIucGwvUEtJL2NydC9UZWwtU3Rlcl9Db2RlU2lnbmluZ0NB
# LmNydDCBhgYDVR0fBH8wfTA+oDygOoY4aHR0cDovL3RlbC1zdGVyLmxvY2FsL1BL
# SS9jcmwvVGVsLVN0ZXJfQ29kZVNpZ25pbmdDQS5jcmwwO6A5oDeGNWh0dHA6Ly90
# ZWwtc3Rlci5wbC9QS0kvY3JsL1RlbC1TdGVyX0NvZGVTaWduaW5nQ0EuY3JsMA0G
# CSqGSIb3DQEBCwUAA4ICAQBBmX/cikpI7L9s0CeenJT2Is4HvdlFDrLQV6DC7ydI
# QlxReAejZLLey/NnMxJvi1ND/3g2z0lm+szT5VSATAHQ9ACcSoZgYib5fHFY/L5l
# ZtmnPVH5CMP1DTbuOTVEASvcCtdR+48DuChGSiXyJbMd/UdwLYL1KinhBOLuoL4o
# XKcEcy//26C/X12a7m94pw20YUvql5wLSmKs9/3MeK1I5X4+VaVy+NMN81ip6w7c
# Aik9i0Z8dUPsCpCG8QpZvcxM/m9vN5ImVsnBNOBzLk3ktco/P8VZl1lIDr+CzXlg
# 6+mk483Tnvkdq1YTlLLVEqxc1/K8XWNe/Ubxyr+7aaRzzmjH960LR52yo5188zTV
# XaMp4lCOpBkHb8DsDXbNHj9pAt/beuSNaknawryxRCBGPsx9mNmRyjrDM8TfB6TY
# tGyuQvVMDpkh4AsK0RNjCT0JdKcn5RL8+IrBcYsSWosJXio1t2SC8AC2UGnAK75r
# 5TIwJ5670ih4BWod26pFTHe6HGgj7xhG2Dd1aDig1BIT89kLy3H/46RD6UKyn1oS
# h9ANeWt0Xz8KedO4TY6Ntui+8c44UckRocl+987u69SnB9jloeiM7gzVYWKw/uDf
# TrxeWriAJzz1CEtJdpdHDrhoSlGoUTyP+uq6LEfMyOkBfXetsBIBalfw/lKkK9mo
# cjCCB0swggUzoAMCAQICAQUwDQYJKoZIhvcNAQELBQAwgYcxCzAJBgNVBAYTAlBM
# MQ8wDQYDVQQHEwZQb3puYW4xETAPBgNVBAoTCFRFTC1TVEVSMRQwEgYDVQQLEwtU
# RUwtU1RFUiBDQTEcMBoGA1UEAxMTVEVMLVNURVIgUm9vdCBDQSB2MzEgMB4GCSqG
# SIb3DQEJARYRYml1cm9AdGVsLXN0ZXIucGwwHhcNMjEwMTI5MTQzOTI2WhcNMzEw
# MTI3MTQzOTI2WjB9MQswCQYDVQQGEwJQTDERMA8GA1UEChMIVEVMLVNURVIxFDAS
# BgNVBAsTC1RFTC1TVEVSIENBMSMwIQYDVQQDExpURUwtU1RFUiBDb2RlU2lnbmlu
# ZyBDQSB2MTEgMB4GCSqGSIb3DQEJARYRYml1cm9AdGVsLXN0ZXIucGwwggIiMA0G
# CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC0d06HEerNOMt8EgzCbBHbKkfaFcPq
# Ty7QuOWY1pV29Muo5zQ7zzD5CN2ANG4qM1vZFLQdVhyB4B1oZm043IYfVbhNhuPN
# Tb0opl59tik/1Or3pjyz+MSXNX27mxs7sMekfHxXMgHfEYBhoJTB6/rtW0pwZmhJ
# fZiaxIUFrQvd3tOZpjYbEDwY71UMl00oGdNxjQlTjrAWNtNSNQbNk2kPkm6PKFcH
# NKDetxZaEN73xXIbMd2k7x+sUcWq79Jyc1nNk3LI8bUu4Tkq3IO9+RI6nCwxf0qT
# lB3xW/ccCKNod/7ka/Ce5SbK9a7AqbaDhQr6hPfjrj1r6aWmPPPO6utJlzIRmvN9
# 9Oa9MG618XEA73zLrb5Yn+ihjUyci3JL9cL2LQfrHM+e3U2H8W/bdvaBS3HrrRR4
# Up261Mmi9jgABsSS9kZkVo23XF4vbV3CyJad2EDx+0nzEbyLN/eb/Z291LWy7Emx
# II2uIA7MamUjaQ3SXUVcT+73Rebr2ZLPnvyyHni8zLRrClQzCDcLBmnId6y1PsOD
# z1JHeYuH8KQbi5qMydyn75/NEvQ6nJMdhUTFA2QcYERqV/KYNIDOepzYImPT4nw4
# dCXdKJXsUt+KmsJBFDkY5aFDgGs4bWF5MxAj9I4RcTIbkSY/RicFqY/02AKHMAAg
# VEWgsHwtmjRf0wIDAQABo4IByTCCAcUwHQYDVR0OBBYEFJtTK95XobbPTBK7ppbt
# zraf7NOzMIG8BgNVHSMEgbQwgbGAFO/ykr4+DfZZ9onN+S6JV4zMon9koYGNpIGK
# MIGHMQswCQYDVQQGEwJQTDEPMA0GA1UEBxMGUG96bmFuMREwDwYDVQQKEwhURUwt
# U1RFUjEUMBIGA1UECxMLVEVMLVNURVIgQ0ExHDAaBgNVBAMTE1RFTC1TVEVSIFJv
# b3QgQ0EgdjMxIDAeBgkqhkiG9w0BCQEWEWJpdXJvQHRlbC1zdGVyLnBsggkAn/K2
# 9yvVrhMwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwSgYIKwYBBQUH
# AQEEPjA8MDoGCCsGAQUFBzAChi5odHRwOi8vdGVsLXN0ZXIucGwvUEtJL2NydC9U
# ZWwtU3Rlcl9Sb290Q0EuY3J0MHgGA1UdHwRxMG8wN6A1oDOGMWh0dHA6Ly90ZWwt
# c3Rlci5sb2NhbC9QS0kvY3JsL1RlbC1TdGVyX1Jvb3RDQS5jcmwwNKAyoDCGLmh0
# dHA6Ly90ZWwtc3Rlci5wbC9QS0kvY3JsL1RlbC1TdGVyX1Jvb3RDQS5jcmwwDQYJ
# KoZIhvcNAQELBQADggIBAI3NRKk4Vl/YXOEg+Pe9Ki5nyyLpwMily4j4SDz9YK9u
# cO4F6RNHAJtFSaES3Nlzker11oARIR7V7ZA6wbxA6eswDKRo2oZjtXDccl6QqECj
# aDIK5ipPSzbg/pUcTvd062pkXpabi39hj9i4/w1fjujQepi9EW696PynoNCBVBWO
# /mMMwviZGzVKBoE5tbCFo0bagVWlRpOQEMgay5L2DJl6qCioxXEyy9Rh6FVBI+dZ
# GfBXdVCDztqJGtlnddlbmuD9XeDNH7h0q/lnr6PLYMwluEdVCmQjo/nIgxNeD9FX
# JArMot8yr+BVc7uq3idciyH7o154pHWv1a4WAr2FPGiAux5C1gNt/3f06u1MOBN3
# ehtl23XHFWgWVq3CGcNdHV+FOw0oxVKd2PqzlpVHHSUcqeJQyA566Zm1m24xH3jC
# z3Ao/ogP8MfkPGGKGtp4TZPkimbEdITIn4Mn4pMd6Uk3MeqesvhjVqqvZjR1Zmm5
# 2pFBPJP1uyzy+2jcGG9qBQ2a02Hp73pSikPPiXH9Ikj8ZjiLAiTMaKwGB1YfkafW
# tAjG3llz8BhUrSFTb17A24x5Cvl/9rJldHVmj3xMQr2Z7rMrpKxW9vswpQNAxV9t
# ZUpfs8/M0+ZrlqW7cEXb3FIcIBAd3xGaxFwMCC7U0L7NfWpMQLyte0cgvi2DGGbn
# MYICNTCCAjECAQEwgYIwfTELMAkGA1UEBhMCUEwxETAPBgNVBAoTCFRFTC1TVEVS
# MRQwEgYDVQQLEwtURUwtU1RFUiBDQTEjMCEGA1UEAxMaVEVMLVNURVIgQ29kZVNp
# Z25pbmcgQ0EgdjExIDAeBgkqhkiG9w0BCQEWEWJpdXJvQHRlbC1zdGVyLnBsAgEB
# MA0GCWCGSAFlAwQCAQUAoIGEMBgGCisGAQQBgjcCAQwxCjAIoAKAAKECgAAwGQYJ
# KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
# gjcCARUwLwYJKoZIhvcNAQkEMSIEIMM3QBlda+HbwJDRAcBzziA5FSwlrvX+Ij3z
# xhxjfUIWMA0GCSqGSIb3DQEBAQUABIIBAC7QEHZnOMNIJUFz8HLSF17GbE1JwqUn
# CY0qKrarAG9A+qgMA4oYJd8r/0mQJ4wCLHObx0tIPnKlg3zSEP1r6T4mI5WTuVdf
# J6f+VgyBIzGxorUnPmLRoTWEMTNr5zEOFPFUy/6rp0gJCmeceTcUTYyNURsCGqA6
# WsHfdhzSy5vrP8UE+l8DsP9RXA+F93+YvuZCrB8VqQ7r+8UhRqrTlmD4/F0PDviJ
# oAqlsqIN/hFdEanmIphUmUMsLt+EJZT2uOj2iFLo2WCycB0RyhsBOKNSUBXPv5Mb
# gAnZ6s031uBHF3ljccVh+N9hPeyvcWufMDE148efsd6E4yZDRbsNW9k=
# SIG # End signature block
